using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using System.Data;

namespace IndianHealthService.BMXNet.Tests
{

    /// <summary>
    /// BMX ADO SS^BMX TEST FILE^^~~~~~
    /// 
    /// </summary>
    /// 
    [TestFixture]
    public class CreateUpdateDeleteChildRows:BmxValidUserTestSuite
    {


        [SetUp]
        public override void Setup()
        {
            base.Setup();
            this.SetupTable();
        }
     
      
        private String _parentIen = null;

        public String ParentIen
        {
            get { return _parentIen; }
            set { _parentIen = value; }
        }


        public override void SetupTable()
        {
            base.SetupTable();

            this.ClearTable();
            this.AddParent(); //necessary so that the next one won't fail
            this.ClearChildTable();
        }

        [Test]
        public void AddParent() {
           DataTable table = this.RemoteSession.TableFromCommand(this.FetchTableString);
           int rowCount = table.Rows.Count;
           DataRow row = table.NewRow();
           row["NAME"] = "Parent";
           row["DATE"] = new DateTime(1970, 10, 10);
           row["NUMBER"] = 8;
           row["NUMBER R/O"] = 9;
           table.Rows.Add(row);
           Assert.AreEqual(rowCount + 1, table.Rows.Count);

           Assert.IsTrue(this.RemoteSession.SaveChanges(table));

           table = this.RemoteSession.TableFromCommand(this.FetchTableString);
           Assert.AreEqual(rowCount + 1, table.Rows.Count);
           row = table.Rows[0];
           Assert.AreEqual(row["NAME"], "Parent");

           this.ParentIen = row["BMXIEN"].ToString();

           Assert.Greater(int.Parse(this.ParentIen), 0);
        }


        public virtual void ClearChildTable()
        {
           
            DataTable table = this.RemoteSession.TableFromCommand(this.FetchString());

            //TODO: is this supposed to work???? table.Rows.Clear();

            foreach (DataRow each in table.Rows)
            {
                each.Delete();
            }
            this.RemoteSession.SaveChanges(table);

            table = this.RemoteSession.TableFromCommand(this.FetchString());
            Assert.AreEqual(0, table.Rows.Count);
        }

     
        public String FetchString() {

            return "BMX ADO SS^BMX TEST FILE2^"+this.ParentIen+",^~~~~~";
        }


        [Test]
        public void TestCarrotLimiter() {
            String result=this.RemoteSession.TransmitRPC("BMX DEMO", "B^10", "OR CPRS GUI CHART");
        }
        
        [Test]
        public void AddRow()
        {


            DataTable table = this.RemoteSession.TableFromCommand(this.FetchString());
            DataRow row = table.NewRow();
            row["BMXIEN1"] = this.ParentIen;
            
            row["NAME2"] = "John";
            row["DATE2"] = new DateTime(1970, 10, 10);
            row["NUMBER2"] = 8;
            row["NUMBER2 R/O"] = 9;
            table.Rows.Add(row);
            Assert.AreEqual(1, table.Rows.Count);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchString());
            Assert.AreEqual(1, table.Rows.Count);
            row = table.Rows[0];
            Assert.AreEqual(row["NAME2"], "John");
            Assert.AreEqual(row["DATE2"], new DateTime(1970, 10, 10));
        }



        [Test]
        public void UpdateRow()
        {
            DataTable table = this.RemoteSession.TableFromCommand(this.FetchString());
            DataRow row = table.NewRow();
            row["BMXIEN1"] = this.ParentIen;
            row["NAME2"] = "John";
            row["DATE2"] = new DateTime(1970, 10, 10);
            row["NUMBER2"] = 8;
            row["NUMBER2 R/O"] = 9;
            table.Rows.Add(row);
            Assert.AreEqual(1, table.Rows.Count);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchString());
            row = table.Rows[0];
            row["NAME2"]="Fred";
            row["DATE2"]= new DateTime(1970, 11, 11);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchString());
            Assert.AreEqual(1, table.Rows.Count);
            row = table.Rows[0];
            Assert.AreEqual(row["NAME2"], "Fred");
            Assert.AreEqual(row["DATE2"], new DateTime(1970, 11, 11));
        }


        [Test]
        public void DeleteRow()
        {
            DataTable table = this.RemoteSession.TableFromCommand(this.FetchString());
            DataRow row = table.NewRow();
            row["BMXIEN1"] = this.ParentIen;
            row["NAME2"] = "John";
            row["DATE2"] = new DateTime(1970, 10, 10);
            row["NUMBER2"] = 8;
            row["NUMBER2 R/O"] = 9;
            table.Rows.Add(row);
            Assert.AreEqual(1, table.Rows.Count);

            row = table.NewRow();
            row["BMXIEN1"] = this.ParentIen;
            row["NAME2"] = "Jane";
            row["DATE2"] = new DateTime(1972, 10, 10);
            row["NUMBER2"] = 8;
            row["NUMBER2 R/O"] = 9;
            table.Rows.Add(row);
            Assert.AreEqual(2, table.Rows.Count);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchString());
            Assert.AreEqual(2, table.Rows.Count);
            row = table.Rows[1];
            Assert.AreEqual(row["NAME2"], "Jane");
            row.Delete();

            //TODO: Deleting a row does not remove it ... it still counts.  Assert below fails
            //if 1
            Assert.AreEqual(2, table.Rows.Count);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchString());
            Assert.AreEqual(1, table.Rows.Count);
            row = table.Rows[0];
            Assert.AreEqual(row["NAME2"],"John");
            
        }




        [Test]
        public void CascadedDeleteRow()
        {

            DataTable table = this.RemoteSession.TableFromCommand(this.FetchString());
            DataRow row = table.NewRow();
            row["BMXIEN1"] = this.ParentIen;
            row["NAME2"] = "John";
            row["DATE2"] = new DateTime(1970, 10, 10);
            row["NUMBER2"] = 8;
            row["NUMBER2 R/O"] = 9;
            table.Rows.Add(row);
            Assert.AreEqual(1, table.Rows.Count);

            Assert.IsTrue(this.RemoteSession.SaveChanges(table));

            table = this.RemoteSession.TableFromCommand(this.FetchString());
            Assert.AreEqual(1, table.Rows.Count);
            row = table.Rows[0];
            Assert.AreEqual(row["NAME2"], "John");
            Assert.AreEqual(row["DATE2"], new DateTime(1970, 10, 10));

            DataTable parentTable = this.RemoteSession.TableFromCommand(this.FetchTableString);
            Assert.AreEqual(1, table.Rows.Count);
            parentTable.Rows[0].Delete();
            Assert.IsTrue(this.RemoteSession.SaveChanges(parentTable));
       
            this.AddParent();
            table = this.RemoteSession.TableFromCommand(this.FetchString());
            Assert.AreEqual(0, table.Rows.Count);

        }




    }
}
